function ver = rccom_getversion(varargin)
% RCCOM_GETVERSION Return version of the current RCCOM server.
%
% ver = RCCOM_GETVERSION() returns string with RCCOM server name and
% version.
%

% ******************************************************************************
% File:      rccom_getversion.m
% Purpose:   Matlab script for getting version of RCCOM server.
% Project:   SESA - RCCOM
% Version:   1.2.0
% Author:    Roman Bartosinski <bartosr@utia.cas.cz>
% Date:      1.8.2006
% 
% Copyright:   
%  (c) 2006 Roman Bartosinski, Dept. of Signal Processing, UTIA/CAS
%           http://sp.utia.cz
% 
% Acknowledgement:
%  This work was partially supported by Academy of Sciences of the Czech
%  Republic under project No. 1ET400750406.
%  
% Description:
%  Matlab script for getting version of RCCOM server.
% 
% Modifications:
%  Date:$date$ Author:$author$
%  Modified: $changes$
%  --
%  
% ******************************************************************************

if nargout>0
    ver = '';
    ver = rcmexfnc('getversion');
else
    rcmexfnc('getversion');
end;
