function objs = rccom_enumobjects(varargin)
% RCCOM_ENUMOBJECTS Get all objects (both, using and cleared)
%
%    OBJS = RCCOM_ENUMOBJECTS() returns cell array of all created rccom
%    objects which are not correctly deleted.
%

% ******************************************************************************
% File:      rccom_enumobjects.m
% Purpose:   Matlab script for enumeration of RCCOM objects.
% Project:   SESA - RCCOM
% Version:   1.2.0
% Author:    Roman Bartosinski <bartosr@utia.cas.cz>
% Date:      1.8.2006
% 
% Copyright:   
%  (c) 2006 Roman Bartosinski, Dept. of Signal Processing, UTIA/CAS
%           http://sp.utia.cz
% 
% Acknowledgement:
%  This work was partially supported by Academy of Sciences of the Czech
%  Republic under project No. 1ET400750406.
%  
% Description:
%  Matlab script for enumeration of RCCOM objects.
% 
% Modifications:
%  Date:$date$ Author:$author$
%  Modified: $changes$
%  --
%  
% ******************************************************************************

uids=[];
uids = rcmexfnc('enumobjects');
objs = cell(size(uids,1),1);
for i=1:size(uids,1)
    objs{i} = rccom(uids(i));
end
