function devs = rccom_enumdevices(iface,varargin)
% RCCOM_ENUMDEVICES Get all devices for the selected target
%
% DEVS = RCCOM_ENUMDEVICES('IFACE') returns cell array of name of all
% connected and ready devices for the selected interface 'IFACE'.
%

% ******************************************************************************
% File:      rccom_enumobjects.m
% Purpose:   Matlab script for enumeration of RCCOM connected devices.
% Project:   SESA - RCCOM
% Version:   1.2.0
% Author:    Roman Bartosinski <bartosr@utia.cas.cz>
% Date:      1.8.2006
% 
% Copyright:   
%  (c) 2006 Roman Bartosinski, Dept. of Signal Processing, UTIA/CAS
%           http://sp.utia.cz
% 
% Acknowledgement:
%  This work was partially supported by Academy of Sciences of the Czech
%  Republic under project No. 1ET400750406.
%  
% Description:
%  Matlab script for enumeration of RCCOM connected devices.
% 
% Modifications:
%  Date:$date$ Author:$author$
%  Modified: $changes$
%  --
%  
% ******************************************************************************

if nargin<1
    error('Not enough input arguments.');
end

if nargout>0
    devs = '';
    devs = rcmexfnc('enumdevices',iface);
else
    rcmexfnc('enumdevices',iface);
end;
