function [varargout] = rcblkprop(action,data,varargin)
% function [varargout] = rcblkprop(action,data,varargin) opens dialog for
% RC library block parameters setting.
% Dialog is invoked by command rcblkprop('init',"gcbh")

if nargin < 2
    error('Too enough input arguments.');
    return;
end

switch action
    case 'open'
        h = findobj('UserData',data);
        if size(h,1)==0
            rcprop_init(data);
        else
            figure(h); % open dialog - set focus to dialog ...
        end

    case 'close'
        h = findobj('UserData',data);
        if size(h,1)~=0
            close(h);
        end

    case 'lb_target'
        rcprop_chngtarget(data);
        
    case 'lb_device'
        rcprop_chngdevice(data);
        
    case 'lb_params'
        rcprop_chng_cfg_item(data);
        
    case 'pb_refresh'
        rcprop_refreshdevice(data);
    
    case 'pb_config'
        rcprop_configurate(data);
        
    case 'ed_input'
        rcproc_chnginput(data);

    case 'ed_output'
        rcproc_chngoutput(data);
        
    case 'pb_parfile'
        rcprop_get_file(data);
        
    case 'pb_ok'
        hfig = get(data,'Parent');
        %disp('Save parameters ...');
        rcprop_saveblockparams(hfig);
        close(hfig); % close dialog

    case 'pb_cancel'
        hfig = get(data,'Parent');
        %disp('Cancel parameters ...');
        close(hfig); % close dialog

    otherwise
        error('Unknown action.');
end

return


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% initialize dialog
function rcprop_init(hblk)
    mysize = [325, 350];
    pos = get(0,'PointerLocation');
    pos(2) = pos(2) - mysize(2);
    size = get(0,'ScreenSize');
    if (pos(1)+mysize(1))>=size(3)
        pos(1) = size(3)-mysize(1)-1;
    end
    if (pos(2)+mysize(2))>=size(4)
        pos(2) = size(4)-mysize(2)-1;
    end
    figpos = [pos(1),pos(2),mysize(1),mysize(2)];
    % FIXME: ? Is 'Units' really always 'pixels' ?
    blkpath = get_param(hblk,'Name'); % FIXME: now it is a name and no path ...
    hdlg = figure('Name',['RC block parameters: ',blkpath],'NumberTitle','off', ...
        'Units','pixels','Toolbar','none','Pointer','crosshair','Pos',figpos, ...
        'WindowStyle','normal','DockControls','off','MenuBar','none','Resize','off', ...
        'Color',[0.75,0.75,0.75]);
    set(hdlg,'UserData',hblk);
% Target communication
    targets = rclibsup('enumtargets');

    hnd = uicontrol(hdlg,'Style','text','String','Communication:','Pos',[5,mysize(2)-25,90,15], ...
        'BackgroundColor',[0.75,0.75,0.75],'HorizontalAlignment','left','Tag','target');
    htgt= uicontrol(hdlg,'Style','popupmenu','String',targets,'Pos',[5,mysize(2)-40-15,100,30], ...
        'Min',0,'Max',0,'TooltipString','Select accessible target', ...
        'Callback','rcblkprop(''lb_target'',gcbo)','Tag','target');
% Device
    hnd = uicontrol(hdlg,'Style','text','String','Device:','Pos',[120,mysize(2)-25,50,15], ...
        'BackgroundColor',[0.75,0.75,0.75],'HorizontalAlignment','left','Enable','off', ...
        'Tag','device');
    hnd = uicontrol(hdlg,'Style','popupmenu','Pos',[120,mysize(2)-40-15,200,30], ...
        'Min',0,'Max',0,'TooltipString','Select accessible devices','Callback', ...
        'rcblkprop(''lb_device'',gcbo)','Enable','off','Tag','device','String','');
    hnd = uicontrol(hdlg,'Style','pushbutton','String','Refresh','Pos',[175,mysize(2)-25,50,18], ...
        'Callback','rcblkprop(''pb_refresh'',gcf)','Tag','device', ...
        'BackgroundColor',[0.75,0.75,0.75],'Enable','off');
    hnd = uicontrol(hdlg,'Style','pushbutton','String','Configuration','Pos',[230,mysize(2)-25,90,18], ...
        'Callback','rcblkprop(''pb_config'',gcf)','Tag','device', ...
        'BackgroundColor',[0.75,0.75,0.75],'Enable','off');

% device settings ... in stand-alone dialog
% block settings
supportedtypes = 'auto|uint8|uint16|uint32|int8|int16|int32';
    % input
    hnd = uicontrol(hdlg,'Style','text','String','Width of input port (0=none,-1=auto):',...
        'Pos',[5,mysize(2)-80,200,15], 'BackgroundColor',[0.75,0.75,0.75],...
        'HorizontalAlignment','left','Enable','on', 'Tag','input');
    twid = get_param(hblk,'rc_inwidth');
    hnd = uicontrol(hdlg,'Style','edit','Pos',[210,mysize(2)-80,30,20],'Min',0,'Max',0,...
        'TooltipString','0=no input,-1=auto','Tag','inwidth','Callback','rcblkprop(''ed_input'',gcf)',...
        'HorizontalAlignment','right','String',twid);
    
    hnd = uicontrol(hdlg,'Style','text','String','Length of input port (0=none,-1=auto):',...
        'Pos',[5,mysize(2)-100,200,15], 'BackgroundColor',[0.75,0.75,0.75],...
        'HorizontalAlignment','left','Enable','on', 'Tag','input');
    tlen = get_param(hblk,'rc_inlength');
    hnd = uicontrol(hdlg,'Style','edit','Pos',[210,mysize(2)-100,30,20],'Min',0,'Max',0,...
        'TooltipString','0=no input,-1=auto','Tag','inlength','Callback','rcblkprop(''ed_input'',gcf)',...
        'HorizontalAlignment','right','String',tlen);
    if strcmp(tlen,'0')==1 | strcmp(twid,'0')==1
        enable = 'off';
    else
        enable = 'on';
    end
    hnd = uicontrol(hdlg,'Style','text','String','Type of data:','Pos',[253,mysize(2)-80,70,15], ...
        'BackgroundColor',[0.75,0.75,0.75],'HorizontalAlignment','left','Enable',enable, ...
        'Tag','intype');
    hnd = uicontrol(hdlg,'Style','popupmenu','Pos',[250,mysize(2)-100,70,20],'Min',0,'Max',0,...
        'TooltipString','Supported types','Tag','intype',...
        'HorizontalAlignment','right','String',supportedtypes,'Enable',enable);
    txt = get_param(hblk,'rc_intype');
    idx = get_popupmenu_index_by_string(hnd,txt);
    if idx<=0
        idx = 1;
    end
    set(hnd,'Value',idx);

    % output
    hnd = uicontrol(hdlg,'Style','text','String','Width of output port (0=none,-1=auto):',...
        'Pos',[5,mysize(2)-130,200,15], 'BackgroundColor',[0.75,0.75,0.75],...
        'HorizontalAlignment','left','Enable','on', 'Tag','output');
    twid = get_param(hblk,'rc_outwidth');
    hnd = uicontrol(hdlg,'Style','edit','Pos',[210,mysize(2)-130,30,20],'Min',0,'Max',0,...
        'TooltipString','0=no output,-1=auto','Tag','outwidth','Callback','rcblkprop(''ed_output'',gcf)',...
        'HorizontalAlignment','right','String',twid);
    
    hnd = uicontrol(hdlg,'Style','text','String','Length of output port (0=none,-1=auto):',...
        'Pos',[5,mysize(2)-150,200,15], 'BackgroundColor',[0.75,0.75,0.75],...
        'HorizontalAlignment','left','Enable','on', 'Tag','output');
    tlen = get_param(hblk,'rc_outlength');
    hnd = uicontrol(hdlg,'Style','edit','Pos',[210,mysize(2)-150,30,20],'Min',0,'Max',0,...
        'TooltipString','0=no output,-1=auto','Tag','outlength','Callback','rcblkprop(''ed_output'',gcf)',...
        'HorizontalAlignment','right','String',tlen);
    if strcmp(tlen,'0')==1 | strcmp(twid,'0')==1
        enable = 'off';
    else
        enable = 'on';
    end
    hnd = uicontrol(hdlg,'Style','text','String','Type of data:','Pos',[253,mysize(2)-130,70,15], ...
        'BackgroundColor',[0.75,0.75,0.75],'HorizontalAlignment','left','Enable',enable, ...
        'Tag','outtype');
    hnd = uicontrol(hdlg,'Style','popupmenu','Pos',[250,mysize(2)-150,70,20],'Min',0,'Max',0,...
        'TooltipString','Supported types','Tag','outtype',...
        'HorizontalAlignment','right','String',supportedtypes,'Enable',enable);
    txt = get_param(hblk,'rc_outtype');
    idx = get_popupmenu_index_by_string(hnd,txt);
    if idx<=0
        idx = 1;
    end
    set(hnd,'Value',idx);

    %choose
    txt = get_param(hblk,'rc_framed');
    if strcmp(txt,'on')==1
        val = 1;
    else
        val = 0;
    end
    hnd = uicontrol(hdlg,'Style','checkbox','String','- use framed data (Signal Processing Blockset is required.)','Pos',[10,mysize(2)-180,300,20], ...
        'HorizontalAlignment','right','BackgroundColor',[0.75,0.75,0.75],'Tag','chframed','Value',val);
    txt = get_param(hblk,'rc_bigendian');
    if strcmp(txt,'on')==1
        val = 1;
    else
        val = 0;
    end    
    hnd = uicontrol(hdlg,'Style','checkbox','String','- send/receive data in BIG-endian format.','Pos',[10,mysize(2)-200,300,20], ...
        'HorizontalAlignment','right','BackgroundColor',[0.75,0.75,0.75],'Tag','chbigendian','Value',val);

    %pre-communication
    hnd = uicontrol(hdlg,'Style','text','String','Number of bytes to read from device before simulation:',...
        'Pos',[5,mysize(2)-230,270,15], 'BackgroundColor',[0.75,0.75,0.75],...
        'HorizontalAlignment','left','Enable','on', 'Tag','predata');
    %txt = get_param(hblk,'rc_outlength');
    txt = '0';
    hnd = uicontrol(hdlg,'Style','edit','Pos',[275,mysize(2)-230,45,20],'Min',0,'Max',0,...
        'Tag','predata','HorizontalAlignment','right','String',txt);
    
    hnd = uicontrol(hdlg,'Style','text','String','Num.of zeros (or name of variable to write before sim.:',...
        'Pos',[5,mysize(2)-250,270,15], 'BackgroundColor',[0.75,0.75,0.75],...
        'HorizontalAlignment','left','Enable','on', 'Tag','predata');
    %txt = get_param(hblk,'rc_outlength');
    hnd = uicontrol(hdlg,'Style','edit','Pos',[275,mysize(2)-250,45,20],'Min',0,'Max',0,...
        'Tag','predata','HorizontalAlignment','right','String',txt);
    txt = get_param(hblk,'rc_refrdfirst');
    if strcmp(txt,'on')==1
        val = 1;
    else
        val = 0;
    end
    hnd = uicontrol(hdlg,'Style','checkbox','String','- read data first (before sim.) then write data',...
        'Pos',[10,mysize(2)-270,300,20], 'HorizontalAlignment','right',...
        'BackgroundColor',[0.75,0.75,0.75],'Tag','chrefrdfirst','Value',val);

% figure buttons
    hnd = uicontrol(hdlg,'Style','pushbutton','String','OK','Pos',[mysize(1)-105,10,100,30], ...
        'Callback','rcblkprop(''pb_ok'',gcbo)','BackgroundColor',[0.75,0.75,0.75]);
    hnd = uicontrol(hdlg,'Style','pushbutton','String','Cancel','Pos',[mysize(1)-210,10,100,30], ...
        'Callback','rcblkprop(''pb_cancel'',gcbo)','BackgroundColor',[0.75,0.75,0.75]);


    seltgt = get_param(hblk,'rc_target');
    if length(seltgt)>0
        tgtidx = get_popupmenu_index_by_string(htgt,seltgt);
    else
        tgtidx = 1;
    end
    if tgtidx>0
        set(htgt,'Value',tgtidx);
        %uicontrol(htgt);
        rcprop_chngtarget(htgt);
    elseif tgtidx<0
        errordlg(['Unknown communication target ''',seltgt,'''!'],'Bad block parameter');
    end

return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% target has been changed
function rcprop_chngtarget(hobj)
    hfig = get(hobj,'Parent');
    block = get(hfig,'UserData');
    blkname = find_system('Handle',block);
    if size(blkname,1)==0 % Block doesn't exist, now
        return;
    end
    %str = get_current_target(hfig);
% enable and fill devices
    hdev = findobj(hfig,'Tag','device');
    set(hdev,'Enable','on');
    hdev = findobj(hdev,'Style','popupmenu');
    rcprop_refreshdevice(hfig);
return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% device has been changed
function rcprop_chngdevice(hobj)
    val = get(hobj,'Value');
    str = get(hobj,'String');
    if (val<=0) | (val>size(str,1))
        return;
    end
    str = str(val,:);
    hfig = get(hobj,'Parent');
    block = get(hfig,'UserData');
    blkname = find_system('Handle',block);
    if size(blkname,1)==0 % Block doesn't exist, now
        return;
    end
    %disp('Change device ...');
    %disp(str);
    % change device settings ...
    
return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% refresh device popupmenu
function rcprop_refreshdevice(hfig)
    hdev = findobj(hfig,'Tag','device','Style','popupmenu');
    if size(hdev,1)==0
        return;
    end
    block = get(hfig,'UserData');
    blkname = find_system('Handle',block);
    if size(blkname,1)==0 % Block doesn't exist, now
        return;
    end
    % enumerate all devices for set target
    target = get_current_target(hfig);
    target = strtrim(target);
    if size(target,2)==0
        set(hdev,'String',' ','Enable','off');
        return;
    end
    devices = rclibsup('enumdevices',target);
    if size(devices,2)==0
        set(hdev,'String',' ','Enable','off');
        devs = findobj(hfig,'Tag','device');
        set(devs,'Enable','off');
        return;
    else
        devs = findobj(hfig,'Tag','device');
        set(devs,'Enable','on');
    end
    % update popupmenu and all parameters ...
    set(hdev,'String',devices,'Enable','on');
    devstr = get_param(block,'rc_device');
    devidx = get_popupmenu_index_by_string(hdev,devstr);
    if devidx>0
        set(hdev,'Value',devidx);
    else
        set(hdev,'Value',1);
    end
    rcprop_chngdevice(hdev);
return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% check input port parameters
function rcproc_chnginput(hfig)
    hobj = findobj(hfig,'Tag','inwidth');
    if size(hobj,1)>0
        w = get(hobj,'String');
    else
        w = '0';
    end
    hobj = findobj(hfig,'Tag','inlength');
    if size(hobj,1)>0
        l = get(hobj,'String');
    else
        l = '0';
    end
    hobj = findobj(hfig,'Tag','intype');
    if strcmp(w,'0')==1 | strcmp(l,'0')==1
        set(hobj,'Enable','off');
    else
        set(hobj,'Enable','on');
    end
return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% check output port parameters
function rcproc_chngoutput(hfig)
    hobj = findobj(hfig,'Tag','outwidth');
    if size(hobj,1)>0
        w = get(hobj,'String');
    else
        w = '0';
    end
    hobj = findobj(hfig,'Tag','outlength');
    if size(hobj,1)>0
        l = get(hobj,'String');
    else
        l = '0';
    end
    hobj = findobj(hfig,'Tag','outtype');
    if strcmp(w,'0')==1 | strcmp(l,'0')==1
        set(hobj,'Enable','off');
    else
        set(hobj,'Enable','on');
    end
return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% parameters will be saved
function rcprop_saveblockparams(hfig)
% get simulink block 
    block = get(hfig,'UserData');
    blkname = find_system('Handle',block);
    if size(blkname,1)==0 % Block doesn't exist, now
        errordlg('Some internal error ? Block doesn''t exist in model!','Save block parameters');
        return;
    end
% save target name
    stgt = get_current_target(hfig);
    if size(stgt,1)==0
        errordlg('Unknown communication target!','Bad parameter');
        return;
    end
    set_param(block,'rc_target',stgt);
% Change block icon
    stgt = lower(stgt);
    if size(strfind(stgt,'celoxica'),2)>0 & size(strfind(stgt,'usb'),2)>0
        imgname = 'rcusb';
    elseif size(strfind(stgt,'serial'),2)>0
        imgname = 'rccom';
    else
        imgname = 'rcunknown';
    end
    imgname = ['image(imread(''private/',imgname,'.bmp''));'];
    set_param(block,'MaskDisplay',imgname);
% save device name
    sdev = get_current_device(hfig);
    if size(sdev,1)==0
        errordlg('Unknown device!','Bad parameter');
        return;
    end
    set_param(block,'rc_device',sdev);
% save device configuration ...

% save block parameters - input, output, ....
    hobj = findobj(hfig,'Tag','inwidth','Style','edit');
    if (hobj)
        set_param(block,'rc_inwidth',get(hobj,'String'));
    end
    hobj = findobj(hfig,'Tag','inlength','Style','edit');
    if (hobj)
        set_param(block,'rc_inlength',get(hobj,'String'));
    end
    hobj = findobj(hfig,'Tag','intype','Style','popupmenu');
    if (hobj)
        all = get(hobj,'String');
        idx = get(hobj,'Value');
        set_param(block,'rc_intype',strtrim(all(idx,:)));
    end
    hobj = findobj(hfig,'Tag','outwidth','Style','edit');
    if (hobj)
        set_param(block,'rc_outwidth',get(hobj,'String'));
    end
    hobj = findobj(hfig,'Tag','outlength','Style','edit');
    if (hobj)
        set_param(block,'rc_outlength',get(hobj,'String'));
    end
    hobj = findobj(hfig,'Tag','outtype','Style','popupmenu');
    if (hobj)
        all = get(hobj,'String');
        idx = get(hobj,'Value');
        set_param(block,'rc_outtype',strtrim(all(idx,:)));
    end
    hobj = findobj(hfig,'Tag','chframed','Style','checkbox');
    if (hobj)
        val = get(hobj,'Value');
        if val==1
            set_param(block,'rc_framed','on');
        else
            set_param(block,'rc_framed','off');
        end
    end
    hobj = findobj(hfig,'Tag','chbigendian','Style','checkbox');
    if (hobj)
        val = get(hobj,'Value');
        if val==1
            set_param(block,'rc_bigendian','on');
        else
            set_param(block,'rc_bigendian','off');
        end
    end
    
return


function rcprop_configurate(hfig)
    stgt = get_current_target(hfig);
    sdev = get_current_device(hfig);
  % open new window with list of parameters and fields for settings
    sdlg = [390,260];
    pos = get(0,'PointerLocation');
    pos(2) = pos(2) - sdlg(2);
    size = get(0,'ScreenSize');
    if (pos(1)+sdlg(1))>=size(3)
        pos(1) = size(3)-sdlg(1)-1;
    end
    if (pos(2)+sdlg(2))>=size(4)
        pos(2) = size(4)-sdlg(2)-1;
    end
    figpos = [pos(1),pos(2),sdlg(1),sdlg(2)];
    hdlg = dialog('Name',['Set Parameters for ',sdev],'Pos',figpos,'Color',[0.85,0.85,0.85],...
        'UserData',hfig);
    hnd = uicontrol(hdlg,'Style','text','String','Parameters:','Pos',[5,sdlg(2)-25,70,15], ...
        'BackgroundColor',[0.85,0.85,0.85],'HorizontalAlignment','left');
    hparams = uicontrol(hdlg,'Style','listbox','Pos',[5,sdlg(2)-150,380,120], ...
        'Callback','rcblkprop(''lb_params'',gcf);');
    hnd = uicontrol(hdlg,'Style','pushbutton','String','OK','Pos',[180,sdlg(2)-25,100,20], ...
        'BackgroundColor',[0.85,0.85,0.85],'UserData',[]);
    hnd = uicontrol(hdlg,'Style','pushbutton','String','Cancel','Pos',[285,sdlg(2)-25,100,20], ...
        'BackgroundColor',[0.85,0.85,0.85],'Callback','close(gcf);');

    % settings
    % Number
    hnd = uicontrol(hdlg,'Style','text','Pos',[60,sdlg(2)-180,25,15],...
        'Horizontalalignment','left','Tag','number','String','Min:',...
        'BackgroundColor',[0.85,0.85,0.85],'Visible','off');
    hnd = uicontrol(hdlg,'Style','text','Pos',[90,sdlg(2)-180,70,20],...
        'HorizontalAlignment','left','Tag','number_min','Enable','off','Visible','off',...
        'BackgroundColor',[0.9,0.9,0.85]);
    hnd = uicontrol(hdlg,'Style','text','Pos',[165,sdlg(2)-180,40,15],...
        'Horizontalalignment','left','Tag','number','String','Actual:',...
        'BackgroundColor',[0.85,0.85,0.85],'Visible','off');
    hnd = uicontrol(hdlg,'Style','text','Pos',[207,sdlg(2)-180,70,20],...
        'HorizontalAlignment','left','Tag','number_actual','Enable','off','Visible','off',...
        'BackgroundColor',[0.9,0.9,0.85]);
    hnd = uicontrol(hdlg,'Style','text','Pos',[285,sdlg(2)-180,25,15],...
        'Horizontalalignment','left','Tag','number','String','Max:',...
        'BackgroundColor',[0.85,0.85,0.85],'Visible','off');
    hnd = uicontrol(hdlg,'Style','text','Pos',[315,sdlg(2)-180,70,20],...
        'HorizontalAlignment','left','Tag','number_max','Enable','off','Visible','off',...
        'BackgroundColor',[0.9,0.9,0.85]);
    hnd = uicontrol(hdlg,'Style','text','Pos',[5,sdlg(2)-205,80,15],...
        'Horizontalalignment','left','Tag','number_set','String','Current setting:',...
        'BackgroundColor',[0.85,0.85,0.85],'Visible','off');
    hnd = uicontrol(hdlg,'Style','text','Pos',[90,sdlg(2)-205,295,20],...
        'HorizontalAlignment','left','Tag','number_set_old','Enable','off','Visible','off',...
        'BackgroundColor',[0.9,0.9,0.85]);
    hnd = uicontrol(hdlg,'Style','text','Pos',[5,sdlg(2)-230,80,15],...
        'Horizontalalignment','left','Tag','number_set','String','New setting:',...
        'BackgroundColor',[0.85,0.85,0.85],'Visible','off');
    hnd = uicontrol(hdlg,'Style','edit','Pos',[90,sdlg(2)-230,295,20],...
        'HorizontalAlignment','left','Tag','number_set_new','Visible','off');
    % Text
    hnd = uicontrol(hdlg,'Style','text','Pos',[5,sdlg(2)-180,80,15],...
        'Horizontalalignment','left','Tag','text','String','Actual:',...
        'BackgroundColor',[0.85,0.85,0.85],'Visible','off');
    hnd = uicontrol(hdlg,'Style','text','Pos',[90,sdlg(2)-180,295,20],...
        'HorizontalAlignment','left','Tag','text_actual','Enable','off','Visible','off',...
        'BackgroundColor',[0.9,0.9,0.85]);
    hnd = uicontrol(hdlg,'Style','text','Pos',[5,sdlg(2)-205,80,15],...
        'Horizontalalignment','left','Tag','text_set','String','Current setting:',...
        'BackgroundColor',[0.85,0.85,0.85],'Visible','off');
    hnd = uicontrol(hdlg,'Style','text','Pos',[90,sdlg(2)-205,295,20],...
        'HorizontalAlignment','left','Tag','text_set_old','Enable','off','Visible','off',...
        'BackgroundColor',[0.9,0.9,0.85]);
    hnd = uicontrol(hdlg,'Style','text','Pos',[5,sdlg(2)-230,80,15],...
        'Horizontalalignment','left','Tag','text_set','String','New setting:',...
        'BackgroundColor',[0.85,0.85,0.85],'Visible','off');
    hnd = uicontrol(hdlg,'Style','edit','Pos',[90,sdlg(2)-230,295,20],...
        'HorizontalAlignment','left','Tag','text_set_new','Visible','off');
    % File
    hnd = uicontrol(hdlg,'Style','text','Pos',[5,sdlg(2)-205,80,15],...
        'Horizontalalignment','left','Tag','file_set','String','Current setting:',...
        'BackgroundColor',[0.85,0.85,0.85],'Visible','off');
    hnd = uicontrol(hdlg,'Style','text','Pos',[90,sdlg(2)-205,295,20],...
        'HorizontalAlignment','left','Tag','file_set_old','Enable','off','Visible','off',...
        'BackgroundColor',[0.9,0.9,0.85]);
    hnd = uicontrol(hdlg,'Style','text','Pos',[5,sdlg(2)-230,80,15],...
        'Horizontalalignment','left','Tag','file_set','String','New setting:',...
        'BackgroundColor',[0.85,0.85,0.85],'Visible','off');
    hnd = uicontrol(hdlg,'Style','edit','Pos',[90,sdlg(2)-230,265,20],...
        'HorizontalAlignment','left','Tag','file_set','Visible','off');
    hnd = uicontrol(hdlg,'Style','pushbutton','String','...','Pos',[360,sdlg(2)-230,25,20], ...
                    'Tag','file_set','BackgroundColor',[0.85,0.85,0.85],...
                    'Callback','rcblkprop(''pb_parfile'',gcf);','Visible','off');
    % Boolean
    hnd = uicontrol(hdlg,'Style','text','String','Use','Pos',[5, sdlg(2)-205, 40, 15],...
        'HorizontalAlignment','left','Tag','check_set','Visible','off');
    hnd = uicontrol(hdlg,'Style','checkbox','Pos',[50, sdlg(2)-205, 40, 15],...
        'Tag','check_set_old','Visible','off');
    hnd = uicontrol(hdlg,'Style','text','String','Use','Pos',[5, sdlg(2)-230, 40, 15],...
        'HorizontalAlignment','left','Tag','check_set','Visible','off');
    hnd = uicontrol(hdlg,'Style','checkbox','Pos',[50, sdlg(2)-230, 40, 15],...
        'Tag','check_set_new','Visible','off');
    
    % enum parameters and fill list
    params = rclibsup('enumparams',stgt,sdev);
    if (length(params)>0)
        set(hparams,'UserData',params);
        idxs = [0,find(params=='|')];
        cnt = length(idxs)-1;
        if (cnt>0)          
            list = [];
            for i=1:cnt
                onepar = params(idxs(i)+7:idxs(i+1));
%                disp(onepar);
                if i==cnt
                    list = [list,onepar(1:end-1)];
                else
                    list = [list,onepar(1:end)];
                end
            end
            set(hparams,'String',list);
        end
        % update dialog for parameter 0
        set(hparams,'Value',1);        
        uicontrol(hparams);
        rcprop_chng_cfg_item(gcf);
    else
        % disable all uicontrols except buttons
        rcprop_show_confparams(hdlg, '?','n');
    end

return

function rcprop_chng_cfg_item(hfig)
    hpar = get(hfig,'UserData');
    stgt = get_current_target(hpar);
    sdev = get_current_device(hpar);

    hlst = findobj(hfig,'Style','listbox');
    if size(hlst,1)==0
        return
    end
    hbtn = findobj(hfig,'Style','pushbutton','String','OK');
    nowset = get(hbtn,'UserData'); % new parameters (currently set)
    enpar = get(hlst,'UserData'); % all enumerated parameters
    idx = get(hlst,'Value');
    pars = [0,find(enpar=='|')];
    parofs = pars(idx)+1; parlen = pars(idx+1)-parofs;
    
    rcprop_show_confparams(hfig,enpar(parofs+3),enpar(parofs+5));
    
    % show current param from device
    omin = findobj(hfig,'-regexp','Tag','_min','Visible','on');
    oact = findobj(hfig,'-regexp','Tag','_actual','Visible','on');
    omax = findobj(hfig,'-regexp','Tag','_max','Visible','on');
    if length(omin) | length(oact) | length(omax)
        % read
        minstr ='';
        actstr ='';
        maxstr ='';
        vals = rclibsup('readparam',stgt,sdev,enpar(parofs:parofs+2));
        if length(vals)
            vidx = strfind(vals,enpar(parofs:parofs+2));
            vidx = [vidx,length(vals)+2];
            for i=1:size(vidx,2)-1
                switch lower(vals(vidx(i)+3))
                    case 'a'
                        actstr = vals(vidx(i)+4:vidx(i+1)-2);
                    case 'l'
                        minstr = vals(vidx(i)+4:vidx(i+1)-2);
                    case 'h'
                        maxstr = vals(vidx(i)+4:vidx(i+1)-2);
                end
            end
        end
        % set
        if length(omin)
            set(omin,'String',minstr);
        end
        if length(oact)
            set(oact,'String',actstr);
        end
        if length(omax)
            set(omax,'String',maxstr);
        end
    end
    % show current setted
    hblk = get(hpar,'UserData');
    curpar = get_param(hblk,'rc_devconf');
    obj = findobj(hfig,'-regexp','Tag','_set_old','Visible','on');
    if ishandle(obj)
        % read
        curset = strfind(curpar,enpar(parofs:parofs+2));
        csend = find(curpar=='|');
        csmyend = find(csend>curset);
        if length(csmyend)>0
            csend = csend(csmyend(1))-1;
        else
            csend = length(curpar);
        end
        str = curpar(curset+3:csend);
        % set
        set(obj,'String',str);
    end
    % preset
    obj = findobj(hfig,'-regexp','Tag','$_set','Visible','on');
    if ishandle(obj)
        % read
        str = 'xxx';
        % set
        set(obj,'String',str);
    end
    
return

function rcprop_get_file(hfig)
    [FileName,PathName] = uigetfile('*.bit','Select bitstream file');
    if ischar(FileName)==1
        hedit = findobj(hfig,'Tag','actual');
        if ishandle(hedit)
            set(hedit,'String',[PathName,FileName]);
        end
    end
return

function rcprop_show_confparams(hfig, type, read)
    objs=findobj(hfig,'-regexp','Tag','number');
    set(objs,'Visible','off');
    objs=findobj(hfig,'-regexp','Tag','text');
    set(objs,'Visible','off');
    objs=findobj(hfig,'-regexp','Tag','file');
    set(objs,'Visible','off');
    switch lower(type)
        case 'f'
            stxt = 'file';
        case 't'
            stxt = 'text';
        case '?'
            stxt = '_nothing_'
        otherwise
            stxt = 'number';
    end
    switch lower(read)
        case 'w'
            objs=findobj(hfig,'-regexp','Tag',[stxt,'_set']);
        case 'b'
            objs=findobj(hfig,'-regexp','Tag',stxt);
        case 'r'
            objs=findobj(hfig,'Tag',stxt);
            objs=[objs;findobj(hfig,'Tag',[stxt,'_actual'])];
        otherwise
            objs = [];
    end
%    objs=findobj(hfig,'-regexp','Tag',stxt);
    set(objs,'Visible','on');           
return
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Auxiliary functions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function index = get_popupmenu_index_by_string(hobj,str)
    slen = size(str,2);
    if slen<1
        index = 0;
        return;
    end
    allstr = get(hobj,'String');
    cnt = size(allstr,1);
    while cnt>0
        if strncmp(allstr(cnt,:),str(1,:),slen)==1
            index = cnt;
            return;
        end
        cnt = cnt - 1;
    end
    index = -1;
return;
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function starget = get_current_target(hfig)
    hobj = findobj(hfig,'Tag','target','Style','popupmenu'); % find target popup
    if size(hobj,1)==0
        starget = '';
        return
    end
    val = get(hobj,'Value');
    str = get(hobj,'String');
    if (val<=0) | (val>size(str,1))
        starget = '';
        return;
    end
    starget = strtrim(str(val,:));
return

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function sdevice = get_current_device(hfig)
    hobj = findobj(hfig,'Tag','device','Style','popupmenu'); % find device popup
    if size(hobj,1)==0
        sdevice = '';
        return
    end
    val = get(hobj,'Value');
    str = get(hobj,'String');
    if (val<=0) | (val>size(str,1))
        sdevice = '';
        return;
    end
    sdevice = strtrim(str(val,:));
return
