function err = set(rcc, varargin)
%RCCOM/SET Set properties of the RCCOM objects.
%
%   SET(RCC) shows all RCC objects' properties which can be set in the
%   current state.

% ******************************************************************************
% File:      set.m
% Purpose:   Set properties of the RCCOM objects.
% Project:   SESA - RCCOM
% Version:   1.2.0
% Author:    Roman Bartosinski <bartosr@utia.cas.cz>
% Date:      1.8.2006
% 
% Copyright:   
%  (c) 2006 Roman Bartosinski, Dept. of Signal Processing, UTIA/CAS
%           http://sp.utia.cz
% 
% Acknowledgement:
%  This work was partially supported by Academy of Sciences of the Czech
%  Republic under project No. 1ET400750406.
%  
% Description:
%  Set properties of the RCCOM objects.
% 
% Modifications:
%  Date:$date$ Author:$author$
%  Modified: $changes$
%  --
%  
% ******************************************************************************

if nargin==0
    disp('Too few arguments.');
    return;
end
try
    if size(varargin,2)==0
        if nargout>0
            err = rcmexfnc('set',rcc);
        else
            rcmexfnc('set',rcc);
        end
    else
        if nargout>0
            err = rcmexfnc('set',rcc,varargin);
        else
            rcmexfnc('set',rcc,varargin);
        end
    end
catch
    err = {};
end
    
