function rcc = rccom(varargin)
%RCCOM RCCom class constructor
%  rcc = RCCOM(target) creates a RCCom object, which provides connection
%  between application(Matlab) and the first boards via RCCOM server (with
%  selected target).
%  $target is name of a required target for communication. For example
%  known targets are 'serial' and 'Celoxica USB'. The known targets can be
%  obtained with command RCCOM_ENUMTARGETS.
%
%  rcc = RCCOM(target,devicename) creates a RCCom object with set target
%  and device by its name (if there exists more devices with the same name
%  than one the first one will be selected.
%
%  rcc = RCCOM(target,deviceindex) creates a RCCom object with  set target
%  and device by its index.

% ******************************************************************************
% File:      rccom.m
% Purpose:   RCCOM class constructor.
% Project:   SESA - RCCOM
% Version:   1.2.0
% Author:    Roman Bartosinski <bartosr@utia.cas.cz>
% Date:      1.8.2006
% 
% Copyright:   
%  (c) 2006 Roman Bartosinski, Dept. of Signal Processing, UTIA/CAS
%           http://sp.utia.cz
% 
% Acknowledgement:
%  This work was partially supported by Academy of Sciences of the Czech
%  Republic under project No. 1ET400750406.
%  
% Description:
%  RCCOM class constructor.
% 
% Modifications:
%  Date:$date$ Author:$author$
%  Modified: $changes$
%  --
%  
% ******************************************************************************

% create a copy of existing object
if (nargin == 1) & isinteger(varargin{1})
    rcb = rcmexfnc('create',varargin{1});
    rcc = class(rcb,'rccom');
    return;
end;

% create a new object
tgt = '';
bname = '';
bidx = -1;
if (nargin > 0) & ischar(varargin{1})
    tgt = varargin{1};
end;
if (nargin > 1)
    if ischar(varargin{2})
        bname = varargin{2};
        %bidx = -1;
    else
        bidx = double(varargin{2});
        %bname = '';
    end;
end;

rcb = rcmexfnc('create',tgt,bname,bidx);
% FIXME: there is an error with function mxSetClassName, so we use matlab
% version of the same function
rcc = class(rcb,'rccom');
