function vals = get(rcc, varargin)
%RCCOM/GET Get values of the RCCOM object properties.
%
%  V = GET(RCC)
%  V = GET(RCC,'Property') returns the value, V, of the specified property,
%      'Property', for the rccom object RCC.
%
%  V = GET(RCC,{'Property1','Property2',...})
%  V = GET(RCC,'Property1','Property2',...)  , both calling format return
%      column vector of cells with the specified properties 'Property1',
%      'Property2', ...

% ******************************************************************************
% File:      get.m
% Purpose:   Get values of the RCCOM object properties.
% Project:   SESA - RCCOM
% Version:   1.2.0
% Author:    Roman Bartosinski <bartosr@utia.cas.cz>
% Date:      1.8.2006
% 
% Copyright:   
%  (c) 2006 Roman Bartosinski, Dept. of Signal Processing, UTIA/CAS
%           http://sp.utia.cz
% 
% Acknowledgement:
%  This work was partially supported by Academy of Sciences of the Czech
%  Republic under project No. 1ET400750406.
%  
% Description:
%  Get values of the RCCOM object properties.
% 
% Modifications:
%  Date:$date$ Author:$author$
%  Modified: $changes$
%  --
%  
% ******************************************************************************

if nargin==0
    disp('Too few arguments.');
    return;
end
try
    if size(varargin,2)==0
        if nargout>0
            vals = rcmexfnc('get',rcc);
        else
            rcmexfnc('get',rcc);
        end
    else
        if nargout>0
            vals = rcmexfnc('get',rcc,varargin);
        else
            ans = rcmexfnc('get',rcc,varargin)
            assignin('base','ans',ans);
        end
    end
catch
    vals = {};
end
