function err = fwrite(rcc, varargin)
%RCCOM/FWRITE Write binary data to RCCOM object.
%
%  ERROR = FWRITE(RCC, DATA) writes all data in DATA in their format.
%
%  ERROR = FWRITE(RCC, DATA, 'PRECISION') writes DATA to RCC object in the
%      specified format.
%
%      In both cases endianing can be changed by RCC object property
%      'Endianing' with 'set' command and the function returns error code,
%      which is zero for successfull writing.

% ******************************************************************************
% File:      fwrite.m
% Purpose:   Write binary data to RCCOM object.
% Project:   SESA - RCCOM
% Version:   1.2.0
% Author:    Roman Bartosinski <bartosr@utia.cas.cz>
% Date:      1.8.2006
% 
% Copyright:   
%  (c) 2006 Roman Bartosinski, Dept. of Signal Processing, UTIA/CAS
%           http://sp.utia.cz
% 
% Acknowledgement:
%  This work was partially supported by Academy of Sciences of the Czech
%  Republic under project No. 1ET400750406.
%  
% Description:
%  Write binary data to RCCOM object.
% 
% Modifications:
%  Date:$date$ Author:$author$
%  Modified: $changes$
%  --
%  
% ******************************************************************************

try
    err = rcmexfnc('fwrite', rcc, varargin);
catch
    err = -1;
end
