function data = fread(rcc, varargin)
%RCCOM/FREAD Read binary data from RCCOM object.
%
%  DATA = FREAD(RCC, COUNT) reads COUNT bytes from RCC object and returns
%      them as a column vector with default type (char)
%
%  DATA = FREAD(RCC, COUNT, 'PRECISION') reads COUNT elements from RCC
%      object and returns them as a column vector. All elements have the
%      same type selected by 'PRECISION' and each element is consisted from
%      N bytes, where N is dependent on given 'PRECISION'.

% ******************************************************************************
% File:      fread.m
% Purpose:   Read binary data from RCCOM object.
% Project:   SESA - RCCOM
% Version:   1.2.0
% Author:    Roman Bartosinski <bartosr@utia.cas.cz>
% Date:      1.8.2006
% 
% Copyright:   
%  (c) 2006 Roman Bartosinski, Dept. of Signal Processing, UTIA/CAS
%           http://sp.utia.cz
% 
% Acknowledgement:
%  This work was partially supported by Academy of Sciences of the Czech
%  Republic under project No. 1ET400750406.
%  
% Description:
%  Read binary data from RCCOM object.
% 
% Modifications:
%  Date:$date$ Author:$author$
%  Modified: $changes$
%  --
%  
% ******************************************************************************

try
    data = rcmexfnc('fread', rcc, varargin);
catch
    data =[];
end
