function ERR = fclose(rcc, varargin)
%RCCOM/FCLOSE Close communication with selected board through RC server.
%
%   ERR = FCLOSE(RCC) closes communication, but it doesn't remove RCC object
%         from memory - DELETE(RCC) command must be used

% ******************************************************************************
% File:      fclose.m
% Purpose:   Close communication with selected board through RC server.
% Project:   SESA - RCCOM
% Version:   1.2.0
% Author:    Roman Bartosinski <bartosr@utia.cas.cz>
% Date:      1.8.2006
% 
% Copyright:   
%  (c) 2006 Roman Bartosinski, Dept. of Signal Processing, UTIA/CAS
%           http://sp.utia.cz
% 
% Acknowledgement:
%  This work was partially supported by Academy of Sciences of the Czech
%  Republic under project No. 1ET400750406.
%  
% Description:
%  Close communication with selected board through RC server.
% 
% Modifications:
%  Date:$date$ Author:$author$
%  Modified: $changes$
%  --
%  
% ******************************************************************************

try
    err = rcmexfnc('fclose',rcc);
catch
    err = -1;
end
