function display(rcc)
%RCCOM/DISPLAY Command window display of a rccom objects
%
%   DISPLAY(OBJ) is called for the object OBJ when the semicolon is not used
%   to terminate a statement.

% ******************************************************************************
% File:      display.m
% Purpose:   Command window display of a RCCOM objects.
% Project:   SESA - RCCOM
% Version:   1.2.0
% Author:    Roman Bartosinski <bartosr@utia.cas.cz>
% Date:      1.8.2006
% 
% Copyright:   
%  (c) 2006 Roman Bartosinski, Dept. of Signal Processing, UTIA/CAS
%           http://sp.utia.cz
% 
% Acknowledgement:
%  This work was partially supported by Academy of Sciences of the Czech
%  Republic under project No. 1ET400750406.
%  
% Description:
%  Command window display of a RCCOM objects.
% 
% Modifications:
%  Date:$date$ Author:$author$
%  Modified: $changes$
%  --
%  
% ******************************************************************************

try
    disp(' ');
    disp([inputname(1),' = ']);
    rcmexfnc('display',rcc);
    disp(' ');
catch
end
