/**
  ******************************************************************************
  * @file    adafruit_802_v2.h
  * @author  MCD Application Team
  * @brief   This file contains definitions for:
  *          - Joystick available on Adafruit 1.8" TFT LCD shield (reference ID 802_v2)
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2018 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef ADAFRUIT_802_V2_H
#define ADAFRUIT_802_V2_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32h7xx_hal_i2c.h"

/** @addtogroup BSP
  * @{
  */

/** @defgroup ADAFRUIT_802_V2 ADAFRUIT_802_v2
  * @{
  */

/** @defgroup ADAFRUIT_802_V2_LOW_LEVEL STM32 ADAFRUIT_802_V2 LOW LEVEL
  * @brief This file provides set of firmware functions to manage joystick
  *        available on Adafruit shield.
  * @{
  */

/** @defgroup ADAFRUIT_802_V2_LOW_LEVEL_Exported_Types LOW LEVEL Exported Types
  * @{
  */

#define ADAFRUIT_802_V2_I2C_ADDR (0x2E << 1)

#define ADAFRUIT_802_V2_RESET_PIN (1ul << 3)


#define ADAFRUIT_802_V2_BUTTON_UP_PIN 6
#define ADAFRUIT_802_V2_BUTTON_UP (1UL << ADAFRUIT_802_V2_BUTTON_UP_PIN)

#define ADAFRUIT_802_V2_BUTTON_DOWN_PIN 9
#define ADAFRUIT_802_V2_BUTTON_DOWN (1UL << ADAFRUIT_802_V2_BUTTON_DOWN_PIN)

#define ADAFRUIT_802_V2_BUTTON_LEFT_PIN 8
#define ADAFRUIT_802_V2_BUTTON_LEFT (1UL << ADAFRUIT_802_V2_BUTTON_LEFT_PIN)

#define ADAFRUIT_802_V2_BUTTON_RIGHT_PIN 5
#define ADAFRUIT_802_V2_BUTTON_RIGHT (1UL << ADAFRUIT_802_V2_BUTTON_RIGHT_PIN)

#define ADAFRUIT_802_V2_BUTTON_IN_PIN 7
#define ADAFRUIT_802_V2_BUTTON_IN (1UL << ADAFRUIT_802_V2_BUTTON_IN_PIN)

#define ADAFRUIT_802_V2_BUTTON_1_PIN 10
#define ADAFRUIT_802_V2_BUTTON_1 (1UL << ADAFRUIT_802_V2_BUTTON_1_PIN)

#define ADAFRUIT_802_V2_BUTTON_2_PIN 11
#define ADAFRUIT_802_V2_BUTTON_2 (1UL << ADAFRUIT_802_V2_BUTTON_2_PIN)

#define ADAFRUIT_802_V2_BUTTON_3_PIN 14
#define ADAFRUIT_802_V2_BUTTON_3 (1UL << ADAFRUIT_802_V2_BUTTON_3_PIN)

#define ADAFRUIT_802_V2_BUTTON_ALL (  \
    ADAFRUIT_802_V2_BUTTON_UP | ADAFRUIT_802_V2_BUTTON_DOWN | ADAFRUIT_802_V2_BUTTON_LEFT | \
    ADAFRUIT_802_V2_BUTTON_RIGHT | ADAFRUIT_802_V2_BUTTON_IN | ADAFRUIT_802_V2_BUTTON_1 | \
    ADAFRUIT_802_V2_BUTTON_2 | ADAFRUIT_802_V2_BUTTON_3 )

/**
  * @}
  */

/** @defgroup ADAFRUIT_802_v2_LOW_LEVEL_Exported_Functions LOW LEVEL Exported_Functions
  * @{
  */

int32_t ADAFRUIT_802_V2_Init(I2C_HandleTypeDef *I2cHandle);
int32_t ADAFRUIT_802_V2_JOY_GetState(I2C_HandleTypeDef *I2cHandle);


/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif /* ADAFRUIT_802_V2_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
