
// Display mode
mode(0);

// Display warning for floating point exception
ieee(1);

clear;

exec("infi_loader.sce");
exec("mkin_loader.sce");
exec("r03_loader.sce");
exec("md81_loader.sce");
exec("sd03_loader.sce");
exec("md45f_ini_loader.sce");
exec("md45f_lat_loader.sce");

disp(" ");
disp("--------------------------------");
disp("Lattice with EF single precision");
disp("--------------------------------");

sys_order=1024;

mur = 1;
ur = zeros(mur,1);u0r = zeros(mur,1);uxr = zeros(mur,1);
rr = eye(mur,mur);

u0r = 0;
cfr = 0.08;

knr = zeros(mur,1);
[knr,mur,tmp1,tmp2] = infi(knr,mur,1,0);
xnr = zeros(mur,1);
[xnr,mur,tmp1,tmp2] = infi(xnr,mur,103,2);
xnpr = zeros(mur,1);
[xnpr,mur,tmp1,tmp2] = infi(xnpr,mur,0,0);

mys = 1;mus = 1;
ipss = 23;yips = 2;
ys = zeros(mys,1);us = zeros(mus,1);es = zeros(mys,1);
kns = zeros(mys,1);
[kns,mys,tmp1,tmp2] = infi(kns,mys,1,0);
xns = zeros(mys,1);
[xns,mys,ipss,yips] = infi(xns,mys,ipss,yips);
xnps = zeros(mys,1);
[xnps,mys,tmp1,tmp2] = infi(xnps,mys,0,0);

lus = sys_order;lys = 0;les = 1;
nus = 0;
kpys = 0;iups = 0;kpus = 0;ieps = 0;kpes = 0;izs = 0;iers = 0;
iyps = mys*lys;kpys = mtlb_s(iyps,mys);
ipss = mus*lus;
iups = mus*nus+ipss;kpus = iups-mus;
ieps = mys*les;kpes = mtlb_s(ieps,mys);
izs = mtlb_a(mtlb_a(mtlb_a(iyps,ipss),ieps),1);
sd03_i = [mys,mus,iyps,kpys,iups,kpus,ieps,kpes,nus,izs];
if mtlb_logic(iyps,">",0) then yps = zeros(iyps,1);else yps = 0;end;
if iups>0 then ups = zeros(iups,1);else ups = 0;end;
if mtlb_logic(ieps,">",0) then eps = zeros(ieps,1);else eps = 0;end;
zs = zeros(izs,1);zs(izs,1) = 1;
b0ps = 0.1;bps = 0.9;aps = 0.98;c0ps = 0.02;cps = 0;
ps = zeros(mys,izs);


[ps,mys,mus,lus,lys,les,izs,b0ps,bps,aps,c0ps,cps,iers] = mkin(ps,mys,mus,lus,lys,les,izs,b0ps,bps,aps,c0ps,cps,iers);

ps(1,1) = 0.11;ps(1,2) = 0.09;ps(1,3) = 0.1;ps(1,sys_order+1) = 0.005;ps(1,5+sys_order+2) = 0;

nbp = 8;                // Number of time points
mps = sys_order+2;      // FIR filterValues 
                        // Time points for change of coefficients

//                                   /\                      /\
// ps(1,1)         _________________/  \____________________/  \_________________
//                 _________________    ____________________    _________________
// ps(1,2)                          \  /                    \  /
//                                   \/                      \/
// ps(1,3)         ______________________________________________________________

jts             = [1,       200,    280,    360,    1200,   1280,   1360,   1500 ];

pns(1,1:8)      = [0.11,    0.11,   0.16,   0.11,   0.11,   0.16,   0.11,   0.11 ];
pns(2,1:8)      = [0.09,    0.09,   0.04,   0.09,   0.09,   0.04,   0.09,   0.09 ];
pns(3,1:8)      = [0.1,     0.1,    0.1,    0.1,    0.1,    0.1,    0.1,    0.1  ];

pns(mps-1,1:8)  = [0.005,   0.005,  0.005,  0.005,  0.005,  0.005,  0.005,  0.005];
pns(mps,1:8)    = [0.000,   0.000,  0.000,  0.000,  0.000,  0.000,  0.000,  0.000];


jtw = 1;
srw = zeros(mps,jtw);

mum = 1;mym = 1;mvm = 1;im = 0;
um = zeros(mum,1);ym = zeros(mym,1);vm = zeros(mvm,1);wm = 0;

lum = sys_order;lym = 0;lvm = 0;lem = 0;l1m = 0;num = 0;
ksm = 0;
if ksm==1 then
  if (lum-lym-1)~=0 then
    disp("error: you have to set lum = lym+1 for ksm ==1");
  end;
end;
kum = 0;kym = 0;kvm = 0;kem = 0;kim = 0;

plot_clr = "g";
kpm = 1;kpim = 1;knm = 0;

izum = mum*(lum+num);jum = izum-mum;
izym = mym*(lym+1);jym = izym-1;
izvm = mvm*lvm;jvm = izvm-mvm;
izem = mym*lem;jem = izem-1;
idm = izum+izym+izvm+izem-mum*num+l1m;

//ilm=idm*(idm-1)/2; %md51, md83, md84

fim = 0.9999;fiexm = 0.9999;

//firm = 1;
//fiqm = fiwm/fiexm;

pm = zeros(idm,1);

dfm = 3;

md45_i = [mum,mym,mvm,izum,jum,izym,jym,izvm,jvm,izem,jem,lum,lym,lvm,lem,num,ksm,kum,kym,kvm,kem,idm];

udm = zeros(mum,1);ydm = zeros(mym,1);vdm = zeros(mvm,1);edm = zeros(mym,1);
zym = zeros(izym,1);
if izum>0 then zum = zeros(izum,1);else zum = 0;end;
if izvm>0 then zvm = zeros(izvm,1);else zvm = 0;end;
if izem>0 then zem = zeros(izem,1);else zem = 0;end;

dm = zeros(idm,1);dm(idm,1) = l1m;
dim = zeros(idm,1);dcm = zeros(idm,1);admm = 1*ones(idm,1);kadm = 12*ones(idm,1);

md45_d = [dm,dim,dcm,admm,kadm];//md46

//dstm = 0;//md44,md46

in_diag = 0.001;
d_inp = in_diag;

lam = in_diag*ones(idm,1);//md70, md44, md46

betm = zeros(idm,1);//md44
bkfm = zeros(idm,1);//md44
bkbm = zeros(idm,1);//md44
betzm = zeros(idm,1);//md44
bkzm = zeros(idm,1);//md44
efpm = zeros(idm,1);//md44
ebpm = zeros(idm,1);//md44
ebdpm = zeros(idm,1);//md44
epm = zeros(idm,1);
alfm = in_diag*ones(idm,1);//md70, md44
albm = in_diag*ones(idm,1);//md70, md44
albdm = in_diag*ones(1,1);//md70, md44
gpm = zeros(idm,1);//md70, md44
gdm = zeros(1,1);
//larm = 1*ones(idm,1);//md70, md44
//alrm = 1*ones(idm,1);//md70, md44

rm = 0;em = 0;efm = 0;

u = ur;y = ys;i = 1;

u = ur;y = ys;

N = 1500;i = 1;ip = 1;in = 150;
NF=1; NT=N;

i_loop = 1;comp_t = 0;

md45_t = zeros(N,14);

tic;
for i = 1:N
  [u,mur,u0r,uxr,rr,cfr,knr,xnr,xnpr] = r03(u,mur,u0r,uxr,rr,cfr,knr,xnr,xnpr);
  [i,jts,pns,jtw,srw,mps,nbp,ps] = md81(i,jts,pns,jtw,srw,mps,nbp,ps);
  [y,u,es,xns,xnps,yps,ups,eps,ps,kns,zs,sd03_i] = sd03(y,u,es,xns,xnps,yps,ups,%eps,ps,kns,zs,sd03_i);
  
  md45_t(i,1) = i;
  md45_t(i,2) = u;
  md45_t(i,3) = y;
  md45_t(i,4) = 0;
  md45_t(i,5) = ps(1);
//md45_t(i,6) = 0; // pm(1)  for model
  md45_t(i,7) = ps(2);
//md45_t(i,8) = 0; // pm(2)  for model
//md45_t(i,9) = 0; // em     for model
//md45_t(i,10) = 0; // efm   for model
//md45_t(i,11) = 0; // pm(1) for DUT
//md45_t(i,12) = 0; // pm(2) for DUT
//md45_t(i,13) = 0; // em    for DUT
//md45_t(i,14) = 0; // efm   for DUT
end;

comp_st = toc();
comp_sts = string(comp_st);
disp("The Simulation Computated in "+comp_sts+" seconds");

fd = mopen('.\lf_d4_1_45f\sci_u.h','w'); M_out = u;
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_u[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_y.h','w'); M_out = y; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_y[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_vm.h','w'); M_out = vm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_vm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_em.h','w'); M_out = em; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_em[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_efm.h','w'); M_out = efm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_efm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_udm.h','w'); M_out = udm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_udm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_ydm.h','w'); M_out = ydm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_ydm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_vdm.h','w'); M_out = vdm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_vdm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_edm.h','w'); M_out = edm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_edm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_zum.h','w'); M_out = zum; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_zum[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_zym.h','w'); M_out = zym; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_zym[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_zvm.h','w'); M_out = zvm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_zvm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_zem.h','w'); M_out = zem; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_zem[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_rm.h','w'); M_out = rm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_rm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_dfm.h','w'); M_out = dfm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_dfm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_fim.h','w'); M_out = fim; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_fim[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_lam.h','w'); M_out = lam; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_lam[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_betm.h','w'); M_out = betm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_betm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_bkfm.h','w'); M_out = bkfm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_bkfm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_bkbm.h','w'); M_out = bkbm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_bkbm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_betzm.h','w'); M_out = betzm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_betzm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_bkzm.h','w'); M_out = bkzm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_bkzm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_efpm.h','w'); M_out = efpm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_efpm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_ebpm.h','w'); M_out = ebpm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_ebpm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_ebdpm.h','w'); M_out = ebdpm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_ebdpm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_epm.h','w'); M_out = epm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_epm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_alfm.h','w'); M_out = alfm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_alfm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_albm.h','w'); M_out = albm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_albm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_albdm.h','w'); M_out = albdm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_albdm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_gpm.h','w'); M_out = gpm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_gpm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_gdm.h','w'); M_out = gdm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_gdm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_fiexm.h','w'); M_out = fiexm; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_fiexm[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_md45_i.h','w'); M_out = md45_i; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_md45_i[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_md45_d.h','w'); M_out = md45_d; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_md45_d[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_N.h','w'); M_out = N; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_N[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_NF.h','w'); M_out = NF; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_NF[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

fd = mopen('.\lf_d4_1_45f\sci_NT.h','w'); M_out = NT; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_NT[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

tic;
     [u,y,vm,em,efm,udm,ydm,vdm,edm,zum,...
     zym,zvm,zem,rm,dfm,fim,lam,betm,bkfm,bkbm,..
     betzm,bkzm,efpm,ebpm,ebdpm,epm,alfm,albm,albdm,gpm,gdm,fiexm,...
     md45_i,md45_d,md45_t,N,NF,NT] = ..
md45f_ini(u,y,vm,em,efm,udm,ydm,vdm,edm,zum,...
     zym,zvm,zem,rm,dfm,fim,lam,betm,bkfm,bkbm,...
     betzm,bkzm,efpm,ebpm,ebdpm,epm,alfm,albm,albdm,gpm,gdm,fiexm,...
     md45_i,md45_d,md45_t,N,NF,NT);
comp_t = toc();
comp_s = string(comp_t);
disp("The Identification ini in "+comp_s+" seconds");

tic;
     [u,y,vm,em,efm,udm,ydm,vdm,edm,zum,...
     zym,zvm,zem,rm,dfm,fim,lam,betm,bkfm,bkbm,..
     betzm,bkzm,efpm,ebpm,ebdpm,epm,alfm,albm,albdm,gpm,gdm,fiexm,...
     md45_i,md45_d,md45_t,N,NF,NT] = ..
md45f_lat(u,y,vm,em,efm,udm,ydm,vdm,edm,zum,...
     zym,zvm,zem,rm,dfm,fim,lam,betm,bkfm,bkbm,...
     betzm,bkzm,efpm,ebpm,ebdpm,epm,alfm,albm,albdm,gpm,gdm,fiexm,...
     md45_i,md45_d,md45_t,N,NF,NT);
comp_t = toc();
comp_s = string(comp_t);
disp("The Identification lat in "+comp_s+" seconds");


fd = mopen('.\lf_d4_1_45f\sci_md45_t.h','w'); M_out = md45_t; 
MN = size(M_out); mfprintf(fd,'%s%d%s\n','float sci_md45_t[',MN(1)*MN(2),'] = {');
for j=1:MN(2) for i=1:MN(1) 
if (i*j == MN(1)*MN(2)) mfprintf(fd,'%18.12e\n',M_out(i,j)); else mfprintf(fd,'%18.12e%s\n',M_out(i,j),','); end 
end end 
mfprintf(fd,'%s\n','};'); mclose(fd);

xx  = md45_t(1:N,1); // time
yy1 = md45_t(1:N,5); // ps(1)
yy2 = md45_t(1:N,6); // pm(1) 
yy3 = md45_t(1:N,7); // ps(2)
yy4 = md45_t(1:N,8); // pm(2) 
yy5 = md45_t(1:N,10);// efm 
yy6 = md45_t(1:N,2); // u

savematfile("lf_45f.mat","comp_t","N","xx","yy1","yy2",'yy3',"yy4","yy5","yy6","-v7");

